/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.gui.base;

import java.util.HashMap;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.FlatGUIPath;
import org.catacomb.druid.build.PanelFactory;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.base.PanelPack;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.report.E;

public class DruKitPanel
extends DruPanel
implements PanelFactory {
    private static final long serialVersionUID = 1L;
    HashMap<String, Realizer> realizers = new HashMap();
    Context context;
    HashMap<String, PanelPack> singletons = new HashMap();

    public void addRealizer(Realizer rlz) {
        if (rlz instanceof IDd) {
            String sid = ((IDd)((Object)rlz)).getID();
            if (sid == null) {
                E.error("each top level item in a kit panel must have an id");
            } else {
                this.realizers.put(sid, rlz);
            }
        } else {
            E.error("kit panel can only add idd cpts - not " + rlz);
        }
    }

    public void setRealizationContext(Context ctx) {
        this.context = ctx;
        if (this.getInfoReceiver() != null) {
            E.warning("resetting ir " + this.getInfoReceiver() + " " + ctx.getInfoAggregator());
        }
        this.setInfoReceiver(ctx.getInfoAggregator());
    }

    public boolean canMake(String sid) {
        return this.realizers.containsKey(sid);
    }

    public PanelPack newPanelPack(String sid) {
        PanelPack ret = null;
        if (this.realizers.containsKey(sid)) {
            Realizer rlz = this.realizers.get(sid);
            this.context.resetStore();
            DruPanel drup = (DruPanel)rlz.realize(this.context, new FlatGUIPath());
            ret = new PanelPack(drup, this.context.getAnonymousComponents(), this.context.getIdentifiedComponents());
        } else {
            E.error("no such item in kit " + sid);
            for (String s : this.realizers.keySet()) {
                E.info("known item: " + s);
            }
        }
        return ret;
    }

    public PanelPack getSingletonPack(String sid) {
        PanelPack ret = null;
        if (this.singletons.containsKey(sid)) {
            ret = this.singletons.get(sid);
        } else {
            ret = this.newPanelPack(sid);
            this.singletons.put(sid, ret);
        }
        return ret;
    }

    public DruPanel showPanel(String sid, Object dest) {
        this.removeAll();
        PanelPack ppk = this.getSingletonPack(sid);
        ppk.actionConnect(dest);
        DruPanel dp = ppk.getMainPanel();
        this.addPanel(dp);
        return dp;
    }
}

