/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.build;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.catacomb.druid.build.AnnotationConnector;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.GUIStore;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.build.Scope;
import org.catacomb.druid.gui.base.DruActionRelay;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.base.PanelWrapper;
import org.catacomb.interlish.service.AppPersist;
import org.catacomb.interlish.service.ResourceAccess;
import org.catacomb.interlish.service.ResourceLoader;
import org.catacomb.interlish.structure.ActionRelay;
import org.catacomb.interlish.structure.ActionSource;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.ControllerSpecifier;
import org.catacomb.interlish.structure.Dialog;
import org.catacomb.interlish.structure.FrameShowable;
import org.catacomb.interlish.structure.GUISourced;
import org.catacomb.interlish.structure.IDable;
import org.catacomb.interlish.structure.InfoExporter;
import org.catacomb.interlish.structure.Marketeer;
import org.catacomb.interlish.structure.Portal;
import org.catacomb.interlish.structure.RootController;
import org.catacomb.interlish.structure.Targetable;
import org.catacomb.interlish.util.JUtil;
import org.catacomb.report.E;
import org.catacomb.util.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Druid
implements Portal {
    String configPath;
    Object rootComponent;
    FrameShowable frameShowable;
    GUIStore guiStore;
    Controller baseController;
    Context parentContext;
    Context context;

    public Druid(String cp) {
        this.configPath = cp;
    }

    public Druid(String cp, Context ctx) {
        this(cp);
        this.parentContext = ctx;
    }

    public void whizzBang() {
        this.buildGUI();
        if (this.rootComponent instanceof ControllerSpecifier) {
            this.selfActivate();
        }
        this.packShow();
        this.context.getMarketplace().logUnresolved();
    }

    public void whizzNoBang() {
        this.buildGUI();
        if (this.rootComponent instanceof ControllerSpecifier) {
            this.selfActivate();
        }
    }

    public void buildGUI() {
        Object obj;
        ResourceLoader resourceLoader = ResourceAccess.getResourceLoader();
        if (!this.configPath.startsWith("com.") && !this.configPath.startsWith("org.") && this.parentContext != null) {
            this.configPath = String.valueOf(this.parentContext.getSourceLocation()) + "." + this.configPath;
        }
        if ((obj = resourceLoader.getResource(this.configPath, null)) == null) {
            E.error("druid cant find config " + this.configPath);
        }
        this.context = new Context(this.parentContext);
        this.context.setSourceLocation(PathUtil.getPackage(this.configPath));
        if (obj instanceof Realizer) {
            this.rootComponent = ((Realizer)obj).realize(this.context, new GUIPath());
            if (this.rootComponent instanceof FrameShowable) {
                this.frameShowable = (FrameShowable)this.rootComponent;
            }
        } else {
            E.fatalError("config does not define an application: " + obj + " " + this.configPath);
            AppPersist.forceExit();
        }
        this.guiStore = this.context.getGUIStore();
    }

    public Object getRootComponent() {
        return this.rootComponent;
    }

    public DruPanel getMainPanel() {
        DruPanel ret = null;
        if (this.rootComponent instanceof DruPanel) {
            ret = (DruPanel)this.rootComponent;
        } else if (this.rootComponent instanceof PanelWrapper) {
            ret = ((PanelWrapper)this.rootComponent).getPanel();
        } else {
            E.error("cant get panel - root=" + this.rootComponent + " " + this.baseController);
        }
        return ret;
    }

    public Controller getController() {
        return this.baseController;
    }

    public FrameShowable getFrameShowable() {
        return this.frameShowable;
    }

    public void packShow() {
        this.pack();
        this.show();
    }

    public void pack() {
        if (this.frameShowable != null) {
            this.frameShowable.pack();
        }
    }

    public void show() {
        if (this.frameShowable != null) {
            this.frameShowable.show();
        }
    }

    public void hide() {
        if (this.frameShowable != null) {
            this.frameShowable.hide();
        }
    }

    @Override
    public void show(Object focusObject) {
        if (this.baseController != null && this.baseController instanceof Targetable) {
            ((Targetable)((Object)this.baseController)).setTarget(focusObject);
        } else {
            E.error("cant show " + focusObject + " with " + this.baseController);
        }
        this.show();
    }

    private void addController(ArrayList<Controller> controllers, Controller ctrl) {
        if (ctrl != null) {
            controllers.add(ctrl);
            if (this.baseController == null) {
                this.baseController = ctrl;
            }
        }
        if (ctrl instanceof RootController) {
            for (Controller coctrl : ((RootController)ctrl).getCoControllers()) {
                this.addController(controllers, coctrl);
            }
        }
    }

    public void selfActivate() {
        if (this.rootComponent instanceof ControllerSpecifier) {
            ArrayList<Controller> controllers = new ArrayList<Controller>();
            ControllerSpecifier cspec = (ControllerSpecifier)this.rootComponent;
            String path = cspec.getControllerPath();
            if (path != null && path.length() > 1) {
                Controller ctrl;
                if (path.indexOf(".") < 0) {
                    path = String.valueOf(PathUtil.getPackage(this.configPath)) + "." + path;
                }
                this.baseController = ctrl = (Controller)JUtil.newInstance(path);
                this.addController(controllers, ctrl);
            }
            if (controllers.size() == 0) {
                E.warning("No controllers found in druid selfActivate");
            } else if (controllers.size() == 1) {
                this.attachSingleController(controllers.get(0));
            } else {
                this.attachMultipleControllers(controllers);
            }
        } else {
            E.warning("druid cant self-activate " + this.rootComponent);
        }
    }

    public void attachSingleController(Controller ctrl) {
        if (ctrl instanceof RootController) {
            E.error("cant attach root controller this way");
        }
        this.baseController = ctrl;
        if (ctrl instanceof InfoExporter) {
            ((InfoExporter)((Object)ctrl)).setInfoReceiver(this.guiStore.getInfoReceiver());
        }
        if (this.guiStore == null) {
            E.warning("no guiStore for controller? " + ctrl);
        } else {
            AnnotationConnector anoc = new AnnotationConnector(this.guiStore.getTargetStore());
            anoc.annotationConnect(ctrl);
            if (ctrl instanceof Marketeer) {
                ((Marketeer)((Object)ctrl)).setMarketplace(this.guiStore.getMarketplace());
            }
            DruActionRelay relay = new DruActionRelay(ctrl);
            for (Object obj : this.guiStore.getComponents()) {
                if (!(obj instanceof ActionSource)) continue;
                ((ActionSource)obj).setActionRelay(relay);
            }
        }
        ctrl.attached();
    }

    public void setID(String id) {
        if (this.rootComponent instanceof IDable) {
            ((IDable)this.rootComponent).setID(id);
        } else {
            E.error("cant set id on " + this.rootComponent);
        }
    }

    public void attachMultipleControllers(ArrayList<Controller> acc) {
        HashMap<String, ActionRelay> pathRelays = new HashMap<String, ActionRelay>();
        DruActionRelay wcRelay = null;
        AnnotationConnector anoc = new AnnotationConnector(this.guiStore.getTargetStore());
        for (Controller ctrl : acc) {
            anoc.annotationConnect(ctrl);
            if (ctrl instanceof Marketeer) {
                ((Marketeer)((Object)ctrl)).setMarketplace(this.guiStore.getMarketplace());
            }
            if (ctrl instanceof InfoExporter) {
                ((InfoExporter)((Object)ctrl)).setInfoReceiver(this.guiStore.getInfoReceiver());
            }
            DruActionRelay druActionRelay = new DruActionRelay(ctrl);
            String ss = "*";
            if (ctrl instanceof GUISourced) {
                ss = ((GUISourced)((Object)ctrl)).getGUISources();
            }
            if (ss.trim().equals("*")) {
                if (wcRelay == null) {
                    wcRelay = druActionRelay;
                    continue;
                }
                E.error("duplicate wildcard controllers " + ctrl);
                continue;
            }
            for (String pth : Scope.getFullPaths(ss)) {
                pathRelays.put(pth, druActionRelay);
            }
        }
        HashMap<String, ArrayList<Object>> hmanon = this.guiStore.getAnonymousComponentMap();
        HashMap<String, Object> hmid = this.guiStore.getIdentifiedComponentMap();
        for (Map.Entry<String, Object> entry : hmid.entrySet()) {
            Object val = entry.getValue();
            if (!(val instanceof ActionSource)) continue;
            ActionRelay ar = this.bestRelay(entry.getKey(), pathRelays, wcRelay);
            ((ActionSource)val).setActionRelay(ar);
        }
        for (Map.Entry<String, Object> entry : hmanon.entrySet()) {
            ActionRelay ar = this.bestRelay(entry.getKey(), pathRelays, wcRelay);
            for (Object val : (ArrayList)entry.getValue()) {
                if (!(val instanceof ActionSource)) continue;
                ((ActionSource)val).setActionRelay(ar);
            }
        }
        for (Controller controller : acc) {
            controller.attached();
        }
    }

    private ActionRelay bestRelay(String path, HashMap<String, ActionRelay> map, ActionRelay wcRelay) {
        ActionRelay ret = null;
        if (map.containsKey(path)) {
            ret = map.get(path);
        } else {
            int ilm = 0;
            for (String sp : map.keySet()) {
                if (!path.startsWith(sp) || sp.length() <= ilm) continue;
                ilm = sp.length();
                ret = map.get(sp);
            }
        }
        if (ret == null && wcRelay != null) {
            ret = wcRelay;
        }
        return ret;
    }

    public void setModal(boolean b) {
        if (this.rootComponent instanceof Dialog) {
            ((Dialog)this.rootComponent).setModal(b);
        } else {
            E.error("cant set modal on " + this.rootComponent.getClass().getName());
        }
    }

    public boolean isShowing() {
        boolean ret = false;
        if (this.rootComponent instanceof Dialog) {
            ret = ((Dialog)this.rootComponent).isShowing();
        } else {
            E.missing();
        }
        return ret;
    }
}

