/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.build;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import org.catacomb.druid.build.ContingencyGroup;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.GUIStore;
import org.catacomb.druid.build.InfoAggregator;
import org.catacomb.druid.market.HookupBoard;
import org.catacomb.interlish.content.ColorSet;
import org.catacomb.interlish.structure.Marketplace;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    ColorSet colorSet;
    HookupBoard hookupBoard;
    GUIStore guiStore;
    static InfoAggregator infoAggregator;
    ArrayList<Object> cache;
    HashMap<String, ContingencyGroup> contingencyGroups;
    String sourceLocation;
    Context parentContext;

    public Context() {
        this(null);
    }

    public Context(Context pc) {
        this.parentContext = pc;
        if (this.parentContext != null) {
            this.colorSet = this.parentContext.copyColorSet();
        } else {
            this.colorSet = new ColorSet();
            this.colorSet.setGray();
        }
        this.guiStore = new GUIStore();
        this.guiStore.setInfoReceiver(this.getInfoAggregator());
    }

    public InfoAggregator getInfoAggregator() {
        if (infoAggregator == null) {
            infoAggregator = new InfoAggregator();
            this.getMarketplace().global().addProducer("Info", infoAggregator, "info");
        }
        return infoAggregator;
    }

    public ContingencyGroup getContingencyGroup(String gnm) {
        if (this.contingencyGroups == null) {
            this.contingencyGroups = new HashMap();
        }
        ContingencyGroup ret = null;
        if (this.contingencyGroups.containsKey(gnm)) {
            ret = this.contingencyGroups.get(gnm);
        } else {
            ret = new ContingencyGroup(gnm);
            this.contingencyGroups.put(gnm, ret);
        }
        return ret;
    }

    public Marketplace getMarketplace() {
        if (this.hookupBoard == null) {
            this.hookupBoard = new HookupBoard();
            this.guiStore.setHookupBoard(this.hookupBoard);
        }
        return this.hookupBoard;
    }

    public Marketplace getMarketplace(String scope) {
        Marketplace hub = this.getMarketplace();
        if (scope != null) {
            if (scope.equals("global")) {
                hub = hub.global();
            } else {
                E.warning("unrecognized scope value " + scope);
            }
        }
        return hub;
    }

    public ColorSet getColorSet() {
        return this.colorSet;
    }

    public ColorSet copyColorSet() {
        return this.colorSet.copy();
    }

    public Color getBg() {
        return this.colorSet.getBackground();
    }

    public Color getFg() {
        return this.colorSet.getForeground();
    }

    public void addToCache(Object obj) {
        if (this.cache == null) {
            this.cache = new ArrayList();
        }
        if (this.cache.contains(obj)) {
            E.info("cache already got - not adding " + obj);
        } else {
            this.cache.add(obj);
        }
    }

    public void addComponent(Object obj, GUIPath gpath) {
        this.guiStore.addComponent(obj, gpath);
    }

    public ArrayList<Object> getCache() {
        return this.cache;
    }

    public void dumpIDs() {
        E.info(this.guiStore.getTextDump());
    }

    public GUIStore getGUIStore() {
        return this.guiStore;
    }

    public Context simpleCopy() {
        Context ctx = new Context();
        ctx.setColorSet(this.colorSet);
        ctx.setInfoAgregator(this.getInfoAggregator());
        return ctx;
    }

    public void setColorSet(ColorSet cs) {
        this.colorSet = cs;
        Color bgColor = this.colorSet.getBackground();
        if (bgColor.getRed() == 240 && bgColor.getGreen() == 240) {
            E.info("*** set the 240 color...");
        }
    }

    public void setInfoAgregator(InfoAggregator ia) {
        infoAggregator = ia;
    }

    public void resetStore() {
        this.guiStore.reset();
    }

    public HashMap<String, Object> getIdentifiedComponents() {
        return this.guiStore.getIdentifiedComponentMap();
    }

    public ArrayList<Object> getAnonymousComponents() {
        return this.guiStore.getAnonymousComponents();
    }

    public void setBg(Color color) {
        this.colorSet.setBg(color);
    }

    public void setSourceLocation(String spkg) {
        this.sourceLocation = spkg;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }
}

