/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.datalish.SColor;
import org.catacomb.druid.blocks.BaseEffect;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.edit.Effect;
import org.catacomb.interlish.structure.IDd;
import org.catacomb.report.E;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Panel
implements Realizer,
IDd {
    public String id;
    public String title;
    public String tip;
    public String info;
    public String border;
    public int borderWidth;
    public int leftBorder = 0;
    public int rightBorder = 0;
    public int topBorder = 0;
    public int bottomBorder = 0;
    public int prefWidth;
    public int prefHeight;
    public String borderTitle;
    public SColor backgroundColor;
    static int panelcount = 0;

    public Panel() {
        ++panelcount;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public final Object realize(Context ctx, GUIPath gpath) {
        gpath = gpath.extend(this.id);
        DruPanel drup = this.instantiatePanel();
        if (this.backgroundColor != null) {
            drup.setBackgroundColor(this.backgroundColor.getColor());
        } else {
            this.backgroundColor = new SColor(ctx.getBg());
            drup.setFallbackBackgroundColor(ctx.getBg());
        }
        this.populatePanel(drup, ctx, gpath);
        this.apply(drup, ctx);
        ctx.addComponent(drup, gpath);
        return drup;
    }

    public abstract DruPanel instantiatePanel();

    public abstract void populatePanel(DruPanel var1, Context var2, GUIPath var3);

    private void apply(DruPanel drup, Context ctx) {
        drup.setFallbackBackgroundColor(ctx.getBg());
        drup.setFallbackForegroundColor(ctx.getFg());
        if (this.id != null && this.id.length() > 0) {
            drup.setID(this.id);
        }
        if (this.prefWidth > 0 || this.prefHeight > 0) {
            if (this.prefHeight == 0) {
                this.prefHeight = this.prefWidth;
            }
            if (this.prefWidth == 0) {
                this.prefWidth = this.prefHeight;
            }
            drup.setPreferredSize(this.prefWidth, this.prefHeight);
        }
        this.applyBorder(drup, ctx);
        if (this.title != null) {
            drup.setTitle(this.title);
        }
        drup.setTip(this.tip);
        drup.setInfo(this.info);
        drup.setInfoReceiver(ctx.getInfoAggregator());
        drup.postApply();
    }

    private final void applyBorder(DruPanel drup, Context ctx) {
        int[] bds = new int[]{this.leftBorder, this.rightBorder, this.topBorder, this.bottomBorder};
        boolean nonzero = false;
        int i = 0;
        while (i < 4) {
            if (bds[i] == 0) {
                bds[i] = this.borderWidth;
            }
            if (bds[i] != 0) {
                nonzero = true;
            }
            ++i;
        }
        if (nonzero) {
            drup.setEmptyBorder(bds[0], bds[1], bds[2], bds[3]);
        }
        if (this.border != null) {
            if (this.border.equals("etched")) {
                drup.addEtchedBorder(this.backgroundColor.getColor());
            } else if (this.border.equals("sunken")) {
                drup.addSunkenBorder(this.backgroundColor.getColor());
            } else if (!this.border.equals("none")) {
                E.error(" - border style not recognised " + this.border + " (only 'etched' is defined)");
            }
        } else if (this.borderTitle != null) {
            drup.addTitledBorder(this.borderTitle);
        }
    }

    public ArrayList<Effect> realizeEffects(ArrayList<BaseEffect> arl, Context ctx, GUIPath gpath) {
        ArrayList<Effect> ret = null;
        if (arl != null) {
            ret = new ArrayList<Effect>();
            for (BaseEffect bef : arl) {
                ret.add(bef.realize(ctx, gpath));
            }
        }
        return ret;
    }
}

