/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import java.util.ArrayList;
import org.catacomb.druid.blocks.ListClickArea;
import org.catacomb.druid.blocks.Panel;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.gui.base.DruListColorRenderer;
import org.catacomb.druid.gui.base.DruListProgressRenderer;
import org.catacomb.druid.gui.base.DruListQuantityRenderer;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.edit.DruListPanel;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public class List
extends Panel
implements AddableTo {
    public String action;
    public int nrow;
    public String renderer;
    public String order;
    ArrayList<ListClickArea> clickAreas;

    public void add(Object obj) {
        if (obj instanceof ListClickArea) {
            if (this.clickAreas == null) {
                this.clickAreas = new ArrayList();
            }
            this.clickAreas.add((ListClickArea)obj);
        }
    }

    public DruPanel instantiatePanel() {
        if (this.nrow == 0) {
            this.nrow = 10;
        }
        return new DruListPanel(this.nrow);
    }

    public void populatePanel(DruPanel dp, Context ctx, GUIPath gpath) {
        DruListPanel drup = (DruListPanel)dp;
        drup.setAction(this.action);
        if (this.renderer != null) {
            if (this.renderer.equals("quantity")) {
                drup.setCellRenderer(new DruListQuantityRenderer());
            } else if (this.renderer.equals("progress")) {
                drup.setCellRenderer(new DruListProgressRenderer());
            } else if (this.renderer.equals("color")) {
                drup.setCellRenderer(new DruListColorRenderer());
            } else {
                E.error("unrecognized renderer " + this.renderer);
            }
        }
        if (this.order != null) {
            if (this.order.equals("reverse")) {
                drup.setOrder(101);
            } else {
                E.warning("unknown list order " + this.order + " (only know reverse)");
            }
        }
        if (this.clickAreas != null) {
            for (ListClickArea lca : this.clickAreas) {
                drup.addClickAction(lca.makeActor());
            }
        }
    }
}

