/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.druid.blocks;

import org.catacomb.datalish.SColor;
import org.catacomb.druid.blocks.Menu;
import org.catacomb.druid.blocks.MenuBar;
import org.catacomb.druid.blocks.Panel;
import org.catacomb.druid.build.Context;
import org.catacomb.druid.build.GUIPath;
import org.catacomb.druid.build.Realizer;
import org.catacomb.druid.gui.base.DruFrame;
import org.catacomb.druid.gui.base.DruMenuBar;
import org.catacomb.druid.gui.base.DruPanel;
import org.catacomb.druid.gui.base.UIColors;
import org.catacomb.interlish.structure.AddableTo;
import org.catacomb.report.E;

public class Frame
implements AddableTo,
Realizer {
    public String title;
    public MenuBar menuBar;
    public Panel panel;
    public String info;
    public String id;
    public SColor backgroundColor;
    public int prefWidth;
    public int prefHeight;

    public Frame() {
    }

    public Frame(String ttl, MenuBar mb, Panel p) {
        this.title = ttl;
        this.menuBar = mb;
        this.panel = p;
    }

    public void add(Object obj) {
        if (obj instanceof Panel) {
            if (this.panel != null) {
                E.error("can only have one panel in a frame");
            } else {
                this.panel = (Panel)obj;
            }
        } else if (obj instanceof MenuBar) {
            this.menuBar = (MenuBar)obj;
        } else if (obj instanceof Menu) {
            if (this.menuBar == null) {
                this.menuBar = new MenuBar();
            }
            this.menuBar.add(obj);
        } else {
            E.error("cant add to frame: " + obj);
        }
    }

    public Object realize(Context ctx, GUIPath gpath) {
        gpath = gpath.extend(this.id);
        if (this.backgroundColor != null) {
            ctx.setBg(this.backgroundColor.getColor());
        }
        UIColors.initialize(ctx.getBg());
        DruFrame axf = new DruFrame(this.title != null ? this.title : "");
        axf.setID(this.id);
        axf.setBackgroundColor(ctx.getBg());
        if (this.menuBar != null) {
            DruMenuBar amb = (DruMenuBar)this.menuBar.realize(ctx, gpath);
            axf.setDruMenuBar(amb);
        }
        if (this.panel != null) {
            DruPanel axp = (DruPanel)this.panel.realize(ctx, gpath);
            axf.setDruPanel(axp);
        }
        ctx.addComponent(axf, gpath);
        if (this.info != null && this.info.length() > 1) {
            ctx.getInfoAggregator().receiveInfo(this.title, this.info);
        }
        if (this.prefWidth > 0 || this.prefHeight > 0) {
            if (this.prefHeight == 0) {
                this.prefHeight = this.prefWidth;
            }
            if (this.prefWidth == 0) {
                this.prefWidth = this.prefHeight;
            }
            axf.setPreferredSize(this.prefWidth, this.prefHeight);
        }
        return axf;
    }
}

