/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.read;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.catacomb.numeric.data.DataItem;
import org.catacomb.numeric.data.DataSetArray;
import org.catacomb.numeric.data.FloatScalar;
import org.catacomb.numeric.data.FloatVector;
import org.catacomb.numeric.data.NumDataSet;
import org.catacomb.report.E;

public class NumericDataRW {
    public static final byte CODE_NUM_DATA_SET = 1;
    public static final byte CODE_FLOAT_SCALAR = 2;
    public static final byte CODE_FLOAT_VECTOR = 3;
    public static final byte CODE_DATA_SET_ARRAY = 4;

    public static byte[] binarize(NumDataSet dset) {
        byte[] ret = new byte[]{};
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            BufferedOutputStream bufos = new BufferedOutputStream(bout);
            DataOutputStream dos = new DataOutputStream(bufos);
            NumericDataRW.write(dos, dset);
            dos.close();
            bufos.flush();
            ret = bout.toByteArray();
        }
        catch (Exception ex) {
            E.error("cant binarize " + dset + " " + ex);
            ex.printStackTrace();
        }
        return ret;
    }

    public static void write(DataOutputStream dos, Object obj) throws IOException {
        if (obj instanceof NumDataSet) {
            NumDataSet dset = (NumDataSet)obj;
            dos.write(1);
            NumericDataRW.writeString(dos, dset.getName());
            dos.writeInt(dset.size());
            for (DataItem dit : dset.getValues()) {
                NumericDataRW.write(dos, dit);
            }
        } else if (obj instanceof FloatVector) {
            FloatVector fv = (FloatVector)obj;
            dos.write(3);
            NumericDataRW.writeString(dos, fv.getName());
            double[] da = fv.getValue();
            dos.writeInt(da.length);
            int i = 0;
            while (i < da.length) {
                dos.writeDouble(da[i]);
                ++i;
            }
        } else if (obj instanceof FloatScalar) {
            FloatScalar fs = (FloatScalar)obj;
            dos.write(2);
            NumericDataRW.writeString(dos, fs.getName());
            dos.writeDouble(fs.getValue());
        } else if (obj instanceof DataSetArray) {
            DataSetArray dsa = (DataSetArray)obj;
            dos.write(4);
            NumericDataRW.writeString(dos, dsa.getName());
            NumDataSet[] dsets = dsa.getDataSets();
            dos.writeInt(dsets.length);
            int i = 0;
            while (i < dsets.length) {
                NumericDataRW.write(dos, dsets[i]);
                ++i;
            }
        } else {
            E.error("data ion cant write " + obj);
        }
    }

    private static void writeString(DataOutputStream dout, String s) throws IOException {
        if (s == null) {
            E.debugError("null string in binary io");
            s = "error";
        }
        dout.writeInt(s.length());
        dout.write(s.getBytes("US-ASCII"));
    }

    public static Object deBinarize(byte[] bdata) {
        return NumericDataRW.read(bdata);
    }

    public static Object read(byte[] bdata) {
        Object ret = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bdata);
            ret = NumericDataRW.read(bais);
        }
        catch (Exception ex) {
            E.error("read error " + ex);
        }
        return ret;
    }

    public static Object read(InputStream ins) {
        Object ret = null;
        try {
            BufferedInputStream bis = new BufferedInputStream(ins);
            DataInputStream din = new DataInputStream(bis);
            byte[] bh = new byte[256];
            int nread = din.read(bh, 0, bh.length);
            if (nread != bh.length) {
                E.error("string read error - want " + bh.length + " got " + nread);
            }
            ret = NumericDataRW.readDIS(din);
        }
        catch (Exception ex) {
            E.error("read error " + ex);
        }
        return ret;
    }

    private static Object readDIS(DataInputStream din) throws IOException {
        DataItem ret = null;
        byte type = din.readByte();
        int nl = din.readInt();
        byte[] ba = new byte[nl];
        int nread = din.read(ba, 0, nl);
        if (nread != nl) {
            E.error("string read error - want " + nl + " got " + nread);
        }
        String name = new String(ba, "US-ASCII");
        if (type == 1) {
            NumDataSet dset = new NumDataSet(name);
            int nel = din.readInt();
            int i = 0;
            while (i < nel) {
                Object obj = NumericDataRW.readDIS(din);
                dset.add(obj);
                ++i;
            }
            ret = dset;
        } else if (type == 4) {
            int nel = din.readInt();
            NumDataSet[] dsa = new NumDataSet[nel];
            int i = 0;
            while (i < nel) {
                dsa[i] = (NumDataSet)NumericDataRW.readDIS(din);
                ++i;
            }
            DataSetArray arr = new DataSetArray(name, dsa);
            ret = arr;
        } else if (type == 2) {
            double d = din.readDouble();
            FloatScalar fs = new FloatScalar(name, d);
            ret = fs;
        } else {
            if (type == 3) {
                int nel = din.readInt();
                double[] da = new double[nel];
                int i = 0;
                while (i < nel) {
                    da[i] = din.readDouble();
                    ++i;
                }
                FloatVector fv = new FloatVector(name, da);
                return fv;
            }
            E.error("Numeric reader unknown code " + type);
        }
        return ret;
    }
}

