/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.gui;

import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.gui.FramePlayerController;
import org.catacomb.druid.gui.base.DruDataDisplay;
import org.catacomb.druid.gui.edit.DruListPanel;
import org.catacomb.interlish.annotation.ControlPoint;
import org.catacomb.interlish.annotation.Editable;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.content.DoubleValue;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.FrameDisplay;
import org.catacomb.interlish.structure.Value;
import org.catacomb.interlish.structure.ValueWatcher;

public class Mesh2plusTimeController
implements Controller,
FrameDisplay,
ValueWatcher {
    @IOPoint(xid="dataDisplay")
    public DruDataDisplay dataDisplay;
    @Editable(xid="cmin")
    public DoubleValue cmin = new DoubleValue(0.0);
    @Editable(xid="cmax")
    public DoubleValue cmax = new DoubleValue(100.0);
    @IOPoint(xid="variables")
    public DruListPanel variableList;
    @ControlPoint(xid="frameController")
    public FramePlayerController frameController;
    private DataHandler dataHandler;

    public Mesh2plusTimeController() {
        this.cmin.addValueWatcher(this);
        this.cmax.addValueWatcher(this);
    }

    public void setDataHandler(DataHandler dh) {
        this.dataHandler = dh;
        this.dataDisplay.attachGraphicsController(dh);
        this.variableList.setItems(this.dataHandler.getPlotNames());
        this.frameController.applyData(this.dataHandler.getFrameValues());
    }

    public void resetRange() {
        double ca = this.dataHandler.getMinValue();
        double cb = this.dataHandler.getMaxValue();
        this.cmin.reportableSetDouble(ca, this);
        this.cmax.reportableSetDouble(cb, this);
        this.exportColorRange();
    }

    public void attached() {
        this.frameController.setFrameDisplay(this);
    }

    public void showFrame(int ifr) {
        this.dataHandler.setFrame(ifr);
        this.dataDisplay.repaint();
    }

    public void setPlot(String s) {
        this.dataHandler.setPlot(s);
        this.dataDisplay.repaint();
    }

    public void valueChangedBy(Value pv, Object src) {
        this.exportColorRange();
    }

    public void exportColorRange() {
        double clo = this.cmin.getDouble();
        double chi = this.cmax.getDouble();
        this.dataDisplay.setColorRange(clo, chi);
        this.dataDisplay.repaint();
    }

    public void repaint() {
        this.dataDisplay.repaint();
    }
}

