/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.gui;

import java.awt.image.BufferedImage;
import java.io.File;
import org.catacomb.dataview.gui.FramePlayer;
import org.catacomb.druid.gui.edit.DruButton;
import org.catacomb.druid.gui.edit.DruSlider;
import org.catacomb.interlish.annotation.IOPoint;
import org.catacomb.interlish.structure.Controller;
import org.catacomb.interlish.structure.FrameDisplay;
import org.catacomb.movie.gif.AnimatedGifEncoder;
import org.catacomb.report.E;
import org.catacomb.util.AWTUtil;

public class FramePlayerController
implements Controller {
    @IOPoint(xid="slider")
    public DruSlider frameSlider;
    @IOPoint(xid="PauseButton")
    public DruButton pauseButton;
    String sourcePath;
    String displayPath;
    int[] indexes;
    String[] displayValues;
    double speed = 1.0;
    int shownFrame;
    FramePlayer framePlayer;
    boolean isPaused;
    FrameDisplay frameDisplay;

    public void attached() {
    }

    public void applyData(double[] dat) {
        this.displayValues = new String[dat.length];
        this.indexes = new int[dat.length];
        int i = 0;
        while (i < dat.length) {
            this.displayValues[i] = String.format("%.4g", new Double(dat[i]));
            this.indexes[i] = i;
            ++i;
        }
        this.frameSlider.setValues(this.displayValues);
        this.showFrame(0);
    }

    public void showFrame(int iframe) {
        if (iframe < 0) {
            iframe = 0;
        }
        if (iframe >= this.indexes.length) {
            iframe = this.indexes.length - 1;
        }
        if (this.frameSlider != null) {
            this.frameSlider.showValue(iframe);
        }
        this.shownFrame = iframe;
        if (this.frameDisplay != null) {
            this.frameDisplay.showFrame(iframe);
        }
    }

    public void show(Object obj) {
    }

    public void sliderMoved() {
        int ival = this.frameSlider.getValue();
        this.showFrame(ival);
    }

    public void rewind() {
        this.stop();
        this.showFrame(0);
    }

    public void pause() {
        if (this.isPaused) {
            this.dePause();
            this.start();
        } else {
            this.rePause();
            this.stop();
        }
    }

    public void dePause() {
        this.isPaused = false;
        this.pauseButton.setLabelText(" pause ");
    }

    private void rePause() {
        this.isPaused = true;
        this.pauseButton.setLabelText("resume");
    }

    public void play() {
        this.stop();
        this.rewind();
        this.start();
        this.dePause();
    }

    private void start() {
        if (this.indexes != null) {
            this.framePlayer = new FramePlayer(this);
            this.framePlayer.start();
        }
    }

    public void stop() {
        if (this.framePlayer != null) {
            this.framePlayer.stop();
        }
    }

    public void faster() {
        this.speed *= 1.3;
    }

    public void slower() {
        this.speed /= 1.3;
    }

    public boolean canAdvance() {
        return this.indexes != null && this.shownFrame < this.indexes.length - 1;
    }

    public void advance() {
        this.showFrame(this.shownFrame + 1);
    }

    public double getSpeed() {
        return this.speed;
    }

    public void record() {
        E.missing();
    }

    public void miniRecord() {
        E.missing();
    }

    public void makeMovie(File f) {
        this.makeAnimatedGif(f);
    }

    public void makeThumbnailMovie(File f) {
        this.makeMiniAnimatedGif(f, 160, 160);
    }

    public void makeAnimatedGif(File f) {
        this.stop();
        this.rewind();
        AnimatedGifEncoder enc = new AnimatedGifEncoder();
        enc.start(f);
        enc.setDelay(160);
        int ifr = 0;
        E.info("animated gif - frame " + ifr);
        while (this.canAdvance()) {
            this.advance();
            E.info("animated gif - frame " + ++ifr);
        }
        enc.finish();
    }

    public void makeMiniAnimatedGif(File f, int wscl, int hscl) {
        this.stop();
        this.rewind();
        AnimatedGifEncoder enc = new AnimatedGifEncoder();
        enc.start(f);
        enc.setDelay(200);
        int nfr = this.indexes.length;
        int stepsize = nfr / 10;
        if (stepsize < 1) {
            stepsize = 1;
        }
        int ifr = 0;
        while (this.canAdvance()) {
            E.info("animated gif - frame " + ifr);
            BufferedImage bim = null;
            if (ifr == 0) {
                double fo;
                int hf;
                int wf = bim.getWidth();
                double ff = (float)wf / (float)(hf = bim.getHeight());
                if (ff > (fo = (double)((float)wscl / (float)hscl))) {
                    hscl = (int)((double)wscl / ff);
                } else {
                    wscl = (int)((double)hscl * ff);
                }
            }
            BufferedImage bufim = AWTUtil.getScaledBufferedImage(bim, wscl, hscl);
            enc.addFrame(bufim);
            ++ifr;
            int i = 0;
            while (i < stepsize) {
                if (this.canAdvance()) {
                    this.advance();
                }
                ++i;
            }
        }
        enc.finish();
    }

    public void setFrameDisplay(FrameDisplay fd) {
        this.frameDisplay = fd;
    }
}

