/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.File;
import java.util.StringTokenizer;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.graph.gui.Painter;
import org.catacomb.util.FileUtil;

public class SWCDisplay
implements DataHandler {
    Node[] nodes;
    static String[] viewOptions = new String[]{"lines", "boxes", "frame", "solid"};
    String viewStyle = "lines";

    public String[] getViewOptions() {
        return viewOptions;
    }

    public void setViewStyle(String s) {
        this.viewStyle = s;
    }

    public String getMagic() {
        return "cctswc00";
    }

    public void read(File f) {
        String s = FileUtil.readStringFromFile(f);
        StringTokenizer st = new StringTokenizer(s, "\n");
        int npx = st.countTokens();
        this.nodes = new Node[npx];
        while (st.hasMoreTokens()) {
            String sl = st.nextToken();
            StringTokenizer stl = new StringTokenizer(sl, " ");
            if (stl.countTokens() < 6) continue;
            int ip = this.nextInt(stl);
            double x = this.nextDouble(stl);
            double y = this.nextDouble(stl);
            double z = this.nextDouble(stl);
            double r = this.nextDouble(stl);
            int ipar = this.nextInt(stl);
            Node parent = null;
            if (ipar >= 0) {
                parent = this.nodes[ipar];
            }
            this.nodes[ip] = new Node(ip, x, y, z, r, parent);
        }
    }

    private int nextInt(StringTokenizer stl) {
        return Integer.parseInt(stl.nextToken());
    }

    private double nextDouble(StringTokenizer stl) {
        return Double.parseDouble(stl.nextToken());
    }

    public boolean antialias() {
        return false;
    }

    public void instruct(Painter p) {
        if (this.viewStyle.equals("lines")) {
            this.instructLines(p);
        } else if (this.viewStyle.equals("boxes")) {
            this.instructBoxes(p);
        } else if (this.viewStyle.equals("frame")) {
            this.instructFrame(p);
        } else if (this.viewStyle.equals("filled")) {
            this.instructFilled(p);
        }
    }

    private void instructLines(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = 0;
        int n2 = nodeArray.length;
        while (n < n2) {
            Node node = nodeArray[n];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawLine(node.x, node.y, pn.x, pn.y);
                }
                p.fillIntCircle(node.x, node.y, 3);
            }
            ++n;
        }
    }

    private void instructBoxes(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = 0;
        int n2 = nodeArray.length;
        while (n < n2) {
            Node pn;
            Node node = nodeArray[n];
            if (node != null && (pn = node.parent) != null) {
                p.setColorWhite();
                p.drawCarrotSides(node.x, node.y, node.r, pn.x, pn.y, pn.r);
            }
            ++n;
        }
    }

    private void instructFrame(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = 0;
        int n2 = nodeArray.length;
        while (n < n2) {
            Node node = nodeArray[n];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawCarrotSides(node.x, node.y, node.r, pn.x, pn.y, pn.r);
                }
                p.drawCircle(node.x, node.y, node.r);
            }
            ++n;
        }
    }

    private void instructFilled(Painter p) {
        Node[] nodeArray = this.nodes;
        int n = 0;
        int n2 = nodeArray.length;
        while (n < n2) {
            Node node = nodeArray[n];
            if (node != null) {
                Node pn = node.parent;
                if (pn != null) {
                    p.setColorWhite();
                    p.drawLine(node.x, node.y, pn.x, pn.y);
                }
                p.fillIntCircle(node.x, node.y, 3);
            }
            ++n;
        }
    }

    public Box getLimitBox() {
        return null;
    }

    public String[] getPlotNames() {
        return null;
    }

    public double getMinValue() {
        return 0.0;
    }

    public double getMaxValue() {
        return 0.0;
    }

    public double[] getFrameValues() {
        return null;
    }

    public int getContentStyle() {
        return 1;
    }

    public void setFrame(int ifr) {
    }

    public void setPlot(String s) {
    }

    public DataHandler getCoHandler() {
        return null;
    }

    public boolean hasData() {
        return true;
    }

    public String getXAxisLabel() {
        return null;
    }

    public String getYAxisLabel() {
        return null;
    }

    public ViewConfig getViewConfig(String s) {
        return null;
    }

    class Node {
        int index;
        Node parent;
        double x;
        double y;
        double z;
        double r;

        public Node(int i, double ax, double ay, double az, double ar, Node par) {
            this.index = i;
            this.x = ax;
            this.y = ay;
            this.z = az;
            this.r = ar;
            this.parent = par;
        }
    }
}

