/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.formats;

import java.io.File;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.display.ViewConfig;
import org.catacomb.dataview.formats.DataHandler;
import org.catacomb.dataview.formats.MeshDataReader;
import org.catacomb.dataview.formats.TableDataHandler;
import org.catacomb.dataview.formats.TableDataReader;
import org.catacomb.graph.gui.Geom;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;
import org.catacomb.util.ArrayUtil;

public class Mesh2plusTimeDisplay
implements DataHandler {
    String[] plotNames;
    double[] frameValues;
    double[][][] mesh;
    double[][][] data;
    double[][][] innerMesh;
    int varIdx;
    int frameIdx;
    private Box meshBox;
    String plot;
    String viewStyle = "density";
    TableDataHandler coHandler = new TableDataHandler();

    public String getMagic() {
        return "cctdif2d";
    }

    public void read(File f) {
        TableDataReader tdr = new TableDataReader(this.coHandler);
        MeshDataReader mdr = new MeshDataReader(f, tdr);
        mdr.read();
        tdr.fix();
        this.mesh = mdr.getMesh();
        this.data = mdr.getData();
        this.frameValues = mdr.getFrameValues();
        String[] vn = mdr.getValueNames();
        this.plotNames = new String[1 + vn.length];
        this.plotNames[0] = "mesh";
        int i = 0;
        while (i < vn.length) {
            this.plotNames[1 + i] = vn[i];
            ++i;
        }
    }

    public String[] getPlotNames() {
        return this.plotNames;
    }

    public void setPlot(String s) {
        this.varIdx = this.varidx(s);
    }

    private int varidx(String s) {
        int dv = -1;
        int i = 0;
        while (i < this.plotNames.length) {
            if (this.plotNames[i].equals(s)) {
                dv = i - 1;
                break;
            }
            ++i;
        }
        return dv;
    }

    public double[] getFrameData(String s, int fidx) {
        int vi = this.varidx(s);
        double[] ret = this.data[fidx][vi];
        return ret;
    }

    public void setDisplayVariable(int i) {
        this.varIdx = i;
    }

    public double getMinValue() {
        int vi = this.varIdx;
        if (vi < 0) {
            vi = 0;
        }
        return ArrayUtil.minD(this.data[this.frameIdx][vi]);
    }

    public double getMaxValue() {
        int vi = this.varIdx;
        if (vi < 0) {
            vi = 0;
        }
        return ArrayUtil.maxD(this.data[this.frameIdx][vi]);
    }

    public boolean antialias() {
        return false;
    }

    private void makeInnerMesh() {
        this.innerMesh = new double[this.mesh.length][2][];
        int i = 0;
        while (i < this.mesh.length) {
            double[][] di = Geom.innerPolygon(this.mesh[i][0], this.mesh[i][1]);
            this.innerMesh[i][0] = di[0];
            this.innerMesh[i][1] = di[1];
            ++i;
        }
    }

    public void instruct(Painter p) {
        if (this.varIdx < 0) {
            this.instructMesh(p);
        } else {
            this.instructAreas(p);
        }
    }

    public void instructMesh(Painter p) {
        double[] xb;
        int nel = this.mesh.length;
        p.setColorWhite();
        int i = 0;
        while (i < nel) {
            xb = this.mesh[i][0];
            double[] yb = this.mesh[i][1];
            p.drawPolygon(xb, yb, xb.length);
            ++i;
        }
        if (this.innerMesh == null) {
            this.makeInnerMesh();
        }
        p.setColorCyan();
        i = 0;
        while (i < nel) {
            xb = this.innerMesh[i][0];
            double[] dArray = this.innerMesh[i][1];
            ++i;
        }
    }

    public void instructAreas(Painter p) {
        if (this.viewStyle.equals("density")) {
            this.instructDensity(p);
        } else {
            E.info("missing code - drawing density");
            this.instructDensity(p);
        }
    }

    public void instructDensity(Painter p) {
        if (this.frameIdx >= 0 && this.frameIdx < this.data.length && this.varIdx >= 0 && this.varIdx < this.data[this.frameIdx].length) {
            double[] dat = this.data[this.frameIdx][this.varIdx];
            p.drawColoredCells(this.mesh, dat);
        }
    }

    public Box getLimitBox() {
        if (this.meshBox == null && this.mesh != null) {
            this.meshBox = new Box();
            int i = 0;
            while (i < this.mesh.length) {
                this.meshBox.push(this.mesh[i][0], this.mesh[i][1]);
                ++i;
            }
        }
        return this.meshBox;
    }

    public double[] getFrameValues() {
        return this.frameValues;
    }

    public int getContentStyle() {
        return 2;
    }

    public void setFrame(int ifr) {
        this.frameIdx = ifr;
    }

    public String[] getViewOptions() {
        String[] ret = new String[]{"density", "particles"};
        return ret;
    }

    public void setViewStyle(String s) {
        this.viewStyle = s;
    }

    public DataHandler getCoHandler() {
        return this.coHandler;
    }

    public boolean hasData() {
        return true;
    }

    public String getXAxisLabel() {
        return null;
    }

    public String getYAxisLabel() {
        return null;
    }

    public ViewConfig getViewConfig(String s) {
        return null;
    }
}

