/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview.build;

import org.catacomb.datalish.Box;
import org.catacomb.dataview.build.Displayable;
import org.catacomb.graph.gui.Labellee;
import org.catacomb.graph.gui.Painter;
import org.catacomb.numeric.data.DataExtractor;
import org.catacomb.report.E;

public class Line
extends Displayable {
    public double width;
    private int npts;
    private double[] xpts;
    private double[] ypts;
    int ilabel = -1;
    Labellee labellee;

    public void markNeeded(DataExtractor dex) {
        String sif = "-1";
        String xf = this.x.replaceAll("frame", sif);
        String yf = this.y.replaceAll("frame", sif);
        dex.mark(xf);
        dex.mark(yf);
    }

    public void getData(DataExtractor dex, int iframe) {
        String sif = "" + iframe;
        String xf = this.x.replaceAll("frame", sif);
        String yf = this.y.replaceAll("frame", sif);
        this.xpts = dex.getVector(xf);
        this.ypts = dex.getVector(yf);
        if (this.xpts == null || this.ypts == null) {
            this.xpts = null;
            E.error("null data in line - wanted " + this.x + " and " + this.y);
        } else {
            this.npts = this.xpts.length;
            if (this.npts != this.ypts.length) {
                int n = this.ypts.length;
                if (this.npts > n) {
                    this.npts = n;
                }
                E.warning("Line: idfferent array lengths " + this.xpts.length + " and " + this.ypts.length);
            }
        }
        if (this.width < 0.5) {
            this.width = 1.0;
        }
        if (this.label != null) {
            if (this.labellee == null) {
                this.labellee = new Labellee(this.xpts, this.ypts, this.label, this.getColor());
            } else {
                this.labellee.update(this.xpts, this.ypts, this.label, this.getColor());
            }
        }
    }

    public Labellee getLabellee() {
        return this.labellee;
    }

    public void pushBox(Box b) {
        int i = 0;
        while (i < this.npts) {
            b.extendTo(this.xpts[i], this.ypts[i]);
            ++i;
        }
    }

    public void instruct(Painter p, int wf) {
        if (this.xpts != null) {
            p.setColor(this.getColor());
            p.drawPolyline(this.xpts, this.ypts, this.npts, this.getColor(), this.width * (double)wf, true);
        }
    }
}

