/*
 * Decompiled with CFR 0.152.
 */
package org.catacomb.dataview;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.catacomb.datalish.Box;
import org.catacomb.dataview.LinePlotElement;
import org.catacomb.dataview.PlotElement;
import org.catacomb.dataview.PointsPlotElement;
import org.catacomb.druid.gui.base.DruDataDisplay;
import org.catacomb.graph.gui.DataDisplay;
import org.catacomb.graph.gui.PaintInstructor;
import org.catacomb.graph.gui.Painter;
import org.catacomb.report.E;

public class Plot
implements PaintInstructor {
    ArrayList<PlotElement> elements = new ArrayList();
    String xlabel;
    String ylabel;
    double xmin = Double.NaN;
    double xmax = Double.NaN;
    double ymin = Double.NaN;
    double ymax = Double.NaN;

    public static void main(String[] argv) {
        Plot p = new Plot();
        double[] xdat = new double[]{0.1, 0.6, 3.2, 5.8};
        double[] ydat = new double[]{4.5, 3.0, 2.0, 5.0};
        p.setData(xdat, ydat);
        p.makeImage(300, 300, "tst.png");
    }

    public void addLine(double[] xpts, double[] ypts, Color c) {
        this.addLine(xpts, ypts, c, "");
    }

    public void addLine(double[] xpts, double[] ypts, Color c, String s) {
        this.elements.add(new LinePlotElement(xpts, ypts, c, s));
    }

    public void addPoints(double[] xpts, double[] ypts, Color c) {
        this.elements.add(new PointsPlotElement(xpts, ypts, c));
    }

    public void setData(double[] xp, double[] yp) {
        this.elements.add(new LinePlotElement(xp, yp));
    }

    public void setXRange(double xl, double xh) {
        this.xmin = xl;
        this.xmax = xh;
    }

    public void setYRange(double yl, double hy) {
        this.ymin = yl;
        this.ymax = hy;
    }

    public void setXLabel(String s) {
        this.xlabel = s;
    }

    public void setYLabel(String s) {
        this.ylabel = s;
    }

    public void makeImage(int w, int h, String fnm) {
        this.makeImage(w, h, new File(fnm));
    }

    public void makeImage(int w, int h, File fout) {
        double[] xyxy = new double[]{this.xmin, this.ymin, this.xmax, this.ymax};
        this.makeImage(w, h, xyxy, fout);
    }

    public void makeImage(int w, int h, double[] xyxy, File fout) {
        Box b = new Box();
        if (Double.isNaN(xyxy[0]) || Double.isNaN(xyxy[1]) || Double.isNaN(xyxy[2]) || Double.isNaN(xyxy[3])) {
            Box blim = this.getLimitBox();
            b.extendXTo(Double.isNaN(xyxy[0]) ? blim.getXmin() : xyxy[0]);
            b.extendYTo(Double.isNaN(xyxy[1]) ? blim.getYmin() : xyxy[1]);
            b.extendXTo(Double.isNaN(xyxy[2]) ? blim.getXmax() : xyxy[2]);
            b.extendYTo(Double.isNaN(xyxy[3]) ? blim.getYmax() : xyxy[3]);
        } else {
            b.extendTo(xyxy[0], xyxy[1]);
            b.extendTo(xyxy[2], xyxy[3]);
        }
        b.tidyLimits();
        this.makeImage(w, h, b, fout);
    }

    public void makeImage(int w, int h, Box b, File fout) {
        DataDisplay.setBatch();
        DruDataDisplay ddd = new DruDataDisplay(w, h);
        ddd.setBg(Color.gray);
        JFrame f = new JFrame();
        f.getContentPane().add(ddd.getGUIPeer());
        f.pack();
        ddd.attachGraphicsController(this);
        if (this.xlabel != null) {
            ddd.setXAxisLabel(this.xlabel);
        }
        if (this.ylabel != null) {
            ddd.setYAxisLabel(this.ylabel);
        }
        ddd.syncSizes();
        ddd.repaintAll();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ddd.setXRange(b.getXmin(), b.getXmax());
        ddd.setYRange(b.getYmin(), b.getYmax());
        try {
            Thread.sleep(200L);
            ImageIO.write((RenderedImage)ddd.getSnapshot(), "PNG", fout);
        }
        catch (Exception ex) {
            E.error("cant write " + fout + " " + ex);
        }
        f.dispose();
    }

    public boolean antialias() {
        return true;
    }

    public Box getLimitBox() {
        Box b = new Box();
        for (PlotElement pe : this.elements) {
            pe.push(b);
        }
        return b;
    }

    public void instruct(Painter p) {
        for (PlotElement pe : this.elements) {
            pe.instruct(p);
        }
        int ileg = 0;
        for (PlotElement pe : this.elements) {
            String s = pe.getLabel();
            if (s == null || s.length() <= 0) continue;
            p.setColor(pe.getColor());
            p.paintLegend(ileg, s);
            ++ileg;
        }
    }
}

